#! /bin/bash -p
#
# Copyright (c) Omnissa, LLC. All rights reserved.
# This product is protected by copyright and intellectual property laws in the
# United States and other countries as well as by international treaties.
# -- Omnissa Restricted
#
# Omnissa Integrated Printing linux client Setup
#


print_usage() {
   printf "integrated-printing-setup.sh:\nThis script installs/uninstalls prlinuxcupsppd binary. "
   printf "Please note that you will require root provileges to execute this script.\n"

   printf "\nUsage:"
   printf "\nPass -i or --install to install prlinuxcupsppd binary for omnissa integrated printing."
   printf "\nPass -u or --uninstall to uninstall prlinuxcupsppd binary.\n"
}

if [ "$#" = "0" ] ; then
   printf "No Command line options specified!\n"
   print_usage
   exit
fi

#
# Root privileges required to execute this script
#
if [ ! $EUID = "0" ]; then
   printf "Root permission required!\n"
   exit 1
fi

bin=/usr/bin
lib=/usr/lib

#
# install_prlinuxcupsppd():
# This function installs the prlinuxcupsppd binary
#
install_prlinuxcupsppd() {
src=$(dirname "$0")
if [ ! -f $src/prlinuxcupsppd ]; then
   printf "prlinuxcupsppd is not exist!\n"
   exit
fi
if [ ! -d $lib/cupsPPD ]; then
   mkdir -p $lib/cupsPPD
fi

cp -f $src/prlinuxcupsppd $lib/cupsPPD/
chmod 4755 $lib/cupsPPD/prlinuxcupsppd
if [ -f $bin/prlinuxcupsppd ]; then
   rm -f $bin/prlinuxcupsppd
fi
ln -sf $lib/cupsPPD/prlinuxcupsppd $bin/prlinuxcupsppd || true
printf "prlinuxcupsppd is installed.\n"
}

#
# uninstall_prlinuxcupsppd():
# This function uninstalls the prlinuxcupsppd binary
#
uninstall_prlinuxcupsppd() {
rm -f $bin/prlinuxcupsppd
rm -rf $lib/cupsPPD
printf "prlinuxcupsppd is uninstalled.\n"
}


opt=$1

case $opt in
   -u|--uninstall)
      uninstall_prlinuxcupsppd
      exit
   ;;

   -i|--install)
      install_prlinuxcupsppd
      exit
   ;;
   *)
      printf "Unrecognized command line option!\n"
      print_usage
      exit
   ;;
esac